'use client'
import React, { useEffect, useState } from 'react';
import Sidebar from '@/app/Components/Home/Sidebar';
import Header from '@/app/Components/Home/Header';
import Link from 'next/link';
import { useParams, useRouter ,usePathname} from 'next/navigation';
import axios from 'axios';
import Image from 'next/image';
import timezones from '../../../../public/assets/timezone/timezone.json';
import { getCookie } from 'cookies-next';
import { useSelector } from 'react-redux';
import swal from 'sweetalert';
import { generatePassword } from '@/app/utils/generatePassword';
import { FaKey, FaEye, FaEyeSlash } from "react-icons/fa";
import EditBrand from '../../components/EditBrand';
import apiRequest from '@/app/lib/InterceptorAxios/axios';
import { decryptData } from '@/app/utils/DecryptData';
import LoadingSkeletonTable from '../../loading';
const CompaniesPage = () => {
  // const { companyid } = useParams();
  const { companyid } = useParams() || {};

  const [brands, setBrands] = useState([]);
  const router = useRouter();
  const [companyName, setCompanyName] = useState('');
  const [loading, setLoading] = useState(true);
  const [brandsName, setBrandsName] = useState();
  const [error, setError] = useState(null);
  const [showBrandModal, setShowBrandModal] = useState(false); // Brand modal visibility state
  const token = getCookie('token');
  const [showUserModal, setShowUserModal] = useState(false); // User modal visibility state
  const fallbackImageUrl = '@public/assets/images/dp.png';
  const user = useSelector((state) => state.user.userInfo);
  const [passwordVisible, setPasswordVisible] = useState(false)
  const [UpdateBrand, setUpdateBrand] = useState(false);
  const pathname = usePathname();

  useEffect(() => {
    // Retrieve company data from sessionStorage
    const data = sessionStorage.getItem('companyData');
 
    if (data && JSON.parse(data).comp_id ==  companyid) {
      setCompanyName(JSON.parse(data).name);
    }
  }, []);


  // const [EditBrandModel, setEditBrandModel] = useState(false)
  const [logoOption, setLogoOption] = useState('upload')
  const [brandFormData, setBrandFormData] = useState({
    name: '',
    url: '',
    domainName: '',
    phone: '',
    email: '',
    timeZone: '',
    logo: null,
    statusId: 1,
    logoUrl:''
  
  });
  const [userFormData, setUserFormData] = useState({
    company_id: companyid,
    name: '',
    pseudonym: '',
    email: '',
    password: '',
    status: 1,
    role: 3,
    designation:'',
    canCreateUsers: 0,
    canCreateBrand: 0,
     hrm_id:''
  });
  // const fetchBrands = async () => {
  //   try {
  //     const response = await axios-get(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/${companyid}/brands`, {
  //       headers: {
  //         Authorization: `Bearer ${token}`,
  //       },
  //     });
  //     setBrands(response.data);
       
  //     setLoading(false);
  //   } catch (error) {
  //     console.error('Error fetching brands:', error);
  //     setError('Failed to fetch brands');
  //     setLoading(false);
  //   }
  // };
  const fetchBrands = async () => {
    try {
      const response = await apiRequest(
        `/api/companies/${companyid}/brands`,
        'GET'
      );
  
      setBrands(response);
      setLoading(false);
    } catch (error) {
      console.error("Error fetching brands:", error.message);
      setError("Failed to fetch brands");
      setLoading(false);
    }
  };
  
  useEffect(() => {



    fetchBrands();
  }, []);
  useEffect(() => {
    if (UpdateBrand) {
      (async () => {
        await fetchBrands();
        setUpdateBrand(false);
      })();
    }
  }, [UpdateBrand]);
  
  
  const isValidImageUrl = async (url) => {
    try {
      const response = await fetch(url, { method: "HEAD" });
      const contentType = response.headers.get("content-type");
      return response.ok && contentType && contentType.startsWith("image/");
    } catch (error) {
      console.error("Error checking image URL:", error);
      return false;
    }
  };
  const handleEditBrand = (brand)=>{

  }
  const handleBrandInputChange = async(e) => {
    const { name, value } = e.target;

   

    setBrandFormData({
      ...brandFormData,
      [name]: value,
    });
  };

  const handleUserInputChange = (e) => {
    const { name, value } = e.target;
    setUserFormData({
      ...userFormData,
      [name]: name === 'brand_id' ? parseInt(value, 10) : value, // Convert brandid to integer
    });
    
  };

  const handleBrandFileChange = (e) => {
    setBrandFormData({
      ...brandFormData,
      logo: e.target.files[0],
    });
  };

   

  const handleBrandSubmit = async (e) => {
    e.preventDefault();
  
    if (user.userId) {
      const formDataWithFile = new FormData();
      formDataWithFile.append('name', brandFormData.name);
      formDataWithFile.append('url', brandFormData.url);
      formDataWithFile.append('domainName', brandFormData.domainName);
      formDataWithFile.append('phone', brandFormData.phone);
      formDataWithFile.append('email', brandFormData.email);
      formDataWithFile.append('timeZone', brandFormData.timeZone);
      formDataWithFile.append('logo', brandFormData.logo);
      formDataWithFile.append('logoUrl', brandFormData.logoUrl);
      formDataWithFile.append('company_id', companyid);
      formDataWithFile.append('status', brandFormData.statusId);
      formDataWithFile.append('created_by', user.userId);
  
      try {
        await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/brands`, formDataWithFile, {
          headers: {
            'Content-Type': 'multipart/form-data',
            Authorization: `Bearer ${token}`,
          },
        });
  
        swal("Success!", "Brand has been created successfully!", "success");
  
        setShowBrandModal(false);
        setBrandFormData({
          name: '',
          url: '',
          domainName: '',
          phone: '',
          email: '',
          timeZone: '',
          logo: null,
          statusId: 1,
          logoUrl: ''
        });
  
        const response = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/${companyid}/brands`, {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        });
  
       const data =  decryptData(response.data)
        setBrands(data);
      } catch (error) {
        if(error.response.status === 401){
          // Show SweetAlert for "Email already exists" error
      swal("Oops!", "Something went wrong please reload page and try again..", "error");
      }
      else{

        swal("Error", `Error creating brand: ${error.response ? error.response.data.error : error.message}`, "error");
        console.error('Error creating brand:', error);
      }
      }
    } else {
      console.error("User is missing");
    }
  };
  

    const handleUserSubmit = async (e) => {
    e.preventDefault();
  
    if (user.userId) {
      try {

        const created_by = user.userId;
        const company_id = companyid;
                const updatedUserFormData = { ...userFormData, created_by, company_id };
        
        await axios.post(`${process.env.NEXT_PUBLIC_API_URL}/api/users`, updatedUserFormData, {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        });
  
        setShowUserModal(false);
        setUserFormData({
          company_id: companyid,
          name: '',
          pseudonym: '',
          email: '',
          password: '',
          status: 1,
          role: 2,
          designation:'',
          canCreateUsers: 0,
          canCreateBrand: 0,
           hrm_id:''
        })
      // Show success alert if user is created successfully
      swal("Success!", "User created successfully.", "success");
        // Refresh user list after adding (if necessary)
      } catch (error) {
        if (error.response && error.response.status === 400 && error.response.data.error === 'Email already exists') {
          // Handle email already exists error
          console.error("Email already exists. Please use a different email.");
          // alert("Email already exists. Please use a different email.");
        // Show SweetAlert for "Email already exists" error
        swal("Oops!", "Email already exists. Please use a different email.", "error");
        } 
      else  if(error.response.status === 401){
          // Show SweetAlert for "Email already exists" error
      swal("Oops!", "Something went wrong please reload page and try again..", "error");
      }
        else {
          console.error("Error creating user:", error);
        }
      }
    } else {
      console.error("User not found");
    }
  };

  // const openAddUserModel = async () => {
  //   setShowUserModal(true);
  //   const res = await axios.get(`${process.env.NEXT_PUBLIC_API_URL}/api/companies/${companyid}/brandnames`);
    
  //   setBrandsName(res.data);
  // };
  const openAddUserModel = async () => {
    setShowUserModal(true);
    try {
      const brandNames = await apiRequest(`/api/companies/${companyid}/brandnames`, 'GET');
      setBrandsName(brandNames);
    } catch (error) {
      console.error('Error fetching brand names:', error.message);
    }
  };
  if (loading) {
    // return <div>Loading...</div>;
    return <LoadingSkeletonTable/>
  }

  if (error) {
    return <div>Error: {error}</div>;
  }

  return (
    <>
      
        <div className="container-fluid top-bar justify-content-between  d-flex">
          <div className="left-div">
            <h2>Brands </h2>
          </div>
          <div className="right-div left-div">
          <h2>Company: {companyName}</h2>
          </div>
        </div>
        <div className="container-fluid company-header">
          <div className="comp-header-row">
          <button className="btn" onClick={() => setShowBrandModal(true)}>
              Add Brand
            </button>
            <button className="btn ms-2 " onClick={openAddUserModel}>
              Add User
            </button>
          </div>
        </div>
        <div className="container-fluid table-container">
          <table className="table table-striped mt-4">
            <thead>
              <tr>
                <th></th>
                <th>Brand Name</th>
                {/* <th>URL</th> */}
                <th>Domain Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Time Zone</th>
                <th>Created At</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              {brands?.map((brand) => (
                <tr key={brand.id}>
                  <td className='text-center'>
                    <img
                      src={brand.logo}
                      width={25}
                      height={25}
                      alt={brand.name}
                      onError={(e) => e.target.src = '/assets/images/dp.png'}
                    />
                  </td>
                  <td>
                    {brand.name}</td>
                   
                  <td>

                      {/* {brand.url} */}
                  <a href={brand.url} target="_blank" rel="noopener noreferrer">
                    {brand.domain_name}
                    </a>
                  </td>
                  <td>{brand.phone}</td>
                  <td>{brand.email}</td>
                  <td>{brand.time_zone}</td>
                  <td>{new Date(brand.created_at).toLocaleDateString()}</td>
                  <td>{brand.status === 1 ? 'Active' : 'Inactive'}</td>
                  <td className='d-flex justify-content-around table-end-buttons' >
                    <Link href={`/company-management/${companyid}/brands/${brand.id}`} prefetch={false}>
                      <button className="btn btn-sm p-btn  ">View</button>
                    </Link>
                    {/* <button className="btn btn-sm p-0 mx-2 text-sm-center py-2 px-1 m-1 p-btn w-100 " onClick={handleEditBrand(brand)} >Edit</button> */}
                    <EditBrand brand = {brand} setUpdateBrand ={setUpdateBrand}/>
                     <Link prefetch={false} href={`/company-management/${companyid}/brand-assign-user/${brand.id}`}>
                      <button className="btn btn-sm p-0 text-sm-center py-2 px-1   p-btn w-100 ">Assign User</button>
                    </Link>
                   
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
  

      {/* Brand Modal */}
      {showBrandModal && (
  <div className="modal-overlay-comp">
    <div className="modal-brand">
      <div className="modal-header-comp">
        <h5 className="modal-title">Add Brand</h5>
        <button
          type="button"
          className="modal-close"
          onClick={() => setShowBrandModal(false)}
        >
          &times;
        </button>
      </div>
      <div className="modal-body">
        <form onSubmit={handleBrandSubmit}>
          <div className="form-group-row-2">
            <div className="form-group">
              <label htmlFor="name">Brand Name</label>
              <input
                className="form-control"
                type="text"
                id="name"
                name="name"
                value={brandFormData.name}
                onChange={handleBrandInputChange}
                required
              />
            </div>
            <div className="form-group">
              <label htmlFor="url">URL</label>
              <input
                type="text"
                className="form-control"
                id="url"
                name="url"
                value={brandFormData.url}
                onChange={handleBrandInputChange}
                required
              />
            </div>
          </div>
          <div className="form-group-row-2">
            <div className="form-group">
              <label htmlFor="domainName">Domain (ex: domain.com)</label>
              <input
                type="text"
                className="form-control"
                id="domainName"
                name="domainName"
                value={brandFormData.domainName}
                onChange={handleBrandInputChange}
                required
              />
            </div>
            <div className="form-group">
              <label htmlFor="phone">Phone</label>
              <input
                className="form-control"
                type="text"
                id="phone"
                name="phone"
                value={brandFormData.phone}
                onChange={handleBrandInputChange}
                required
              />
            </div>
          </div>
          <div className="form-group-row-2">
            <div className="form-group">
              <label htmlFor="email">Email</label>
              <input
                type="email"
                className="form-control"
                id="email"
                name="email"
                value={brandFormData.email}
                onChange={handleBrandInputChange}
                required
              />
            </div>
            <div className="form-group">
  <label htmlFor="timeZone">Time Zone</label>
  <select
    className="form-control"
    id="timeZone"
    name="timeZone"
    value={brandFormData.timeZone || "US/Pacific"} // Default to US/Pacific
    onChange={handleBrandInputChange}
    required
  >
    <option value="">Select a Time Zone</option>
    {timezones.map((tz) => (
      <option key={tz.zone} value={tz.zone}>
        {tz.gmt + "  " + tz.zone}
      </option>
    ))}
  </select>
</div>

          </div>
          <div className="form-group">
            <label htmlFor="statusId">Status</label>
            <select
              className="form-control"
              id="statusId"
              name="statusId"
              value={brandFormData.statusId}
              onChange={handleBrandInputChange}
            >
              <option value={1}>Active</option>
              <option value={0}>Inactive</option>
            </select>
          </div>
          <div className="form-group">
            <label>Brand Logo</label>
            <div className='brand-logo-container'>
              <div className="form-check">
                <input
                  type="radio"
                  id="uploadFromDevice"
                  name="logoOption"
                  value="upload"
                  checked={logoOption === "upload"}
                  onChange={() => setLogoOption("upload")}
                />
                <label htmlFor="uploadFromDevice" className="form-check-label">
                  Upload from Device
                </label>
              </div>
              <div className="form-check">
                <input
                  type="radio"
                  id="uploadFromUrl"
                  name="logoOption"
                  value="url"
                  checked={logoOption === "url"}
                  onChange={() => setLogoOption("url")}
                />
                <label htmlFor="uploadFromUrl" className="form-check-label">
                  Provide a URL
                </label>
              </div>
            </div>
            {logoOption === "upload" && (
              <input
                className="form-control mt-2"
                type="file"
                id="logoFile"
                name="logoFile"
                onChange={handleBrandFileChange}
                required={logoOption === "upload"}
              />
            )}
            {logoOption === "url" && (
              <input
                className="form-control mt-2"
                type="url"
                id="logoUrl"
                name="logoUrl"
                value={brandFormData.logoUrl || ""}
                onChange={handleBrandInputChange}
                placeholder="Enter image URL"
                required={logoOption === "url"}
              />
            )}
          </div>
          <button type="submit" className="btn submit-btn p-btn mt-3 w-100">
            Add Brand
          </button>
        </form>
      </div>
    </div>
  </div>
)}


      {/* User Modal */}
      {showUserModal && (
        <div className="modal-overlay-comp">
          <div className="modal-brand">
            <div className="modal-header-comp">
              <h5 className="modal-title">Add User</h5>
              <button
                type="button"
                className="modal-close"
                onClick={() => setShowUserModal(false)}
              >
                &times;
              </button>
            </div>
            <div className="modal-body">
              <form onSubmit={handleUserSubmit}>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="name">Name</label>
                    <input
                      className="form-control"
                      type="text"
                      id="name"
                      name="name"
                      value={userFormData.name}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                  <div className="form-group">
                    <label htmlFor="pseudonym">Pseudonym</label>
                    <input
                      type="text"
                      className="form-control"
                      id="pseudonym"
                      name="pseudonym"
                      value={userFormData.pseudonym}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                </div>
                <div className="form-group-row-2">
                  <div className="form-group">
                    <label htmlFor="email">Email</label>
                    <input
                      type="email"
                      className="form-control"
                      id="email"
                      name="email"
                      value={userFormData.email}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
               
                  <div className="form-group">
              <label htmlFor="password">Password:</label>
              <div className="password-input-container" style={{ position: "relative" }}>
                <input
                  className="form-control"
                  type={passwordVisible ? "text" : "password"}
                  id="password"
                  name="password"
                  value={userFormData.password}
                  onChange={handleUserInputChange}
                  required
                />
                <button
                  type="button"
                  onClick={() =>
                    setUserFormData({ ...userFormData, password: generatePassword() })
                  }
                  className="generate-password-btn"
                  style={{
                    position: "absolute",
                    right: "30px",
                    top: "50%",
                    transform: "translateY(-50%)",
                    border: "none",
                    background: "transparent",
                    cursor: "pointer",
                  }}
                  title="Generate Password"
                >
                  <FaKey size={14} color="gray" />
                </button>
                <button
                  type="button"
                  onClick={() => setPasswordVisible(!passwordVisible)}
                  className="toggle-password-btn"
                  style={{
                    position: "absolute",
                    right: "10px",
                    top: "50%",
                    transform: "translateY(-50%)",
                    border: "none",
                    background: "transparent",
                    cursor: "pointer",
                  }}
                  title={passwordVisible ? "Hide Password" : "Show Password"}
                >
                  {passwordVisible ? (
                    <FaEyeSlash size={14} color="gray" />
                  ) : (
                    <FaEye size={14} color="gray" />
                  )}
                </button>
              </div>
            </div>
                </div>
                <div className="form-group">
                    <label htmlFor="designation">HRM ID:</label>
                    <input
                      type="text"
                      className="form-control"
                      id="hrm_id"
                      name="hrm_id"
                      value={userFormData.hrm_id}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>  <div className="form-group">
                    <label htmlFor="designation">Designation:</label>
                    <input
                      type="text"
                      className="form-control"
                      id="designation"
                      name="designation"
                      value={userFormData.designation}
                      onChange={handleUserInputChange}
                      required
                    />
                  </div>
                <div className="form-group">
                  <label htmlFor="status">Status</label>
                  <select
                    className="form-control"
                    id="status"
                    name="status"
                    value={userFormData.status}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={1}>Active</option>
                    <option value={0}>Inactive</option>
                  </select>
                </div>
                <div className="form-group">
                  <label htmlFor="role">Role</label>
                  <select
                    className="form-control"
                    id="role"
                    name="role"
                    value={userFormData.role}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={3} selected>Sales</option>
                    <option value={2}>Admin</option>
                    <option value={4}>Marketing</option>
                    {/* <option value="client">Client</option> */}
                  </select>
                </div>  
                <div className="form-group">
                  <label htmlFor="canCreateUsers">Can Create Users</label>
                  <select
                    className="form-control"
                    id="canCreateUsers"
                    name="canCreateUsers"
                    value={userFormData.canCreateUsers}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={0}>No</option>
                    <option value={1}>Yes</option>
                  </select>
                </div>
                <div className="form-group">
                  <label htmlFor="canCreateBrand">Can Create Brand</label>
                  <select
                    className="form-control"
                    id="canCreateBrand"
                    name="canCreateBrand"
                    value={userFormData.canCreateBrand}
                    onChange={handleUserInputChange}
                    required
                  >
                    <option value={0}>No</option>
                    <option value={1}>Yes</option>
                  </select>
                </div>
                <button type="submit" className="btn submit-btn p-btn mt-3 w-100">
                  Add User
                </button>
              </form>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default CompaniesPage;
